<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-04-08 17:33
 */
interface DamagedproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Damagedproduct 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param damagedproduct primary key
 	 */
	public function delete($damagedProductId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Damagedproduct damagedproduct
 	 */
	public function insert($damagedproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Damagedproduct damagedproduct
 	 */
	public function update($damagedproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductId($value);

	public function queryByMeasurUnitId($value);

	public function queryByProductQuantity($value);

	public function queryByCost($value);

	public function queryByProductionOrderId($value);

	public function queryByOperationDate($value);

	public function queryByUserID($value);

	public function queryByStoreId($value);


	public function deleteByProductId($value);

	public function deleteByMeasurUnitId($value);

	public function deleteByProductQuantity($value);

	public function deleteByCost($value);

	public function deleteByProductionOrderId($value);

	public function deleteByOperationDate($value);

	public function deleteByUserID($value);

	public function deleteByStoreId($value);


}
?>